/*
 * @(#)StyleManager.java  1.0  6. Juni 2006
 *
 * Copyright (c) 2006 Werner Randelshofer (FHZ)
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 *
 * Original code take from article "Swing and CSS" by Joshua Marinacci 10/14/2003
 * http://today.java.net/pub/a/today/2003/10/14/swingcss.html
 */

package ch.randelshofer.swingcss;

import java.awt.*;
import java.util.*;
/**
 * StyleManager.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0 6. Juni 2006 Created.
 */
public class StyleManager {
    private java.util.List<Rule> rules;
    
    public StyleManager() {
        rules = new ArrayList<Rule>();
    }
    
    public void add(Rule rule) {
        rules.add(rule);
    }
    public void addClassRule(Class clss, String property, String value) {
        Rule rule = new ClassRule(clss, property, value);
        rules.add(rule);
    }
    
    public void style(Component comp) {
        // loop over the rules to find matches
        Iterator it = rules.iterator();
        while(it.hasNext()) {
            Rule rule = (Rule)it.next();
            // apply the rule if it matches
            if (rule.matches(comp)) {
                rule.apply(comp);
            }
        }
        
        // loop over the children and call style recursively
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for(int i=0; i<comps.length; i++) {
                style(comps[i]);
            }
        }
    }
    
}
